/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks.tiles;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.blocks.BlockNpcRedstone;
import noppes.npcs.blocks.tiles.TileNpcEntity;
import noppes.npcs.controllers.data.Availability;

public class TileRedstoneBlock
extends TileNpcEntity
implements ITickable {
    public Availability availability = new Availability();
    public boolean isActivated = false;
    public boolean isDetailed = false;
    public int offRange = 20;
    public int offRangeX = 20;
    public int offRangeY = 20;
    public int offRangeZ = 20;
    public int onRange = 12;
    public int onRangeX = 12;
    public int onRangeY = 12;
    public int onRangeZ = 12;
    private int ticks = 10;

    private List<EntityPlayer> getPlayerList(int x, int y, int z) {
        List<Object> list = new ArrayList<EntityPlayer>();
        try {
            list = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)).func_72314_b((double)x, (double)y, (double)z));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("x", this.field_174879_c.func_177958_n());
        compound.func_74768_a("y", this.field_174879_c.func_177956_o());
        compound.func_74768_a("z", this.field_174879_c.func_177952_p());
        compound.func_74768_a("OffRange", this.offRange);
        compound.func_74768_a("OffRangeX", this.offRangeX);
        compound.func_74768_a("OffRangeY", this.offRangeY);
        compound.func_74768_a("OffRangeZ", this.offRangeZ);
        compound.func_74768_a("OnRange", this.onRange);
        compound.func_74768_a("OnRangeX", this.onRangeX);
        compound.func_74768_a("OnRangeY", this.onRangeY);
        compound.func_74768_a("OnRangeZ", this.onRangeZ);
        compound.func_74757_a("IsDetailed", this.isDetailed);
        return compound;
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound compound) {
        this.offRange = compound.func_74762_e("OffRange");
        this.offRangeX = compound.func_74762_e("OffRangeX");
        this.offRangeY = compound.func_74762_e("OffRangeY");
        this.offRangeZ = compound.func_74762_e("OffRangeZ");
        this.onRange = compound.func_74762_e("OnRange");
        this.onRangeX = compound.func_74762_e("OnRangeX");
        this.onRangeY = compound.func_74762_e("OnRangeY");
        this.onRangeZ = compound.func_74762_e("OnRangeZ");
        this.isDetailed = compound.func_74767_n("IsDetailed");
    }

    public void onDataPacket(@Nonnull NetworkManager net, @Nonnull SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.onRange = compound.func_74762_e("BlockOnRange");
        this.offRange = compound.func_74762_e("BlockOffRange");
        this.isDetailed = compound.func_74767_n("BlockIsDetailed");
        this.onRangeX = compound.func_74762_e("BlockOnRangeX");
        this.onRangeY = compound.func_74762_e("BlockOnRangeY");
        this.onRangeZ = compound.func_74762_e("BlockOnRangeZ");
        this.offRangeX = compound.func_74762_e("BlockOffRangeX");
        this.offRangeY = compound.func_74762_e("BlockOffRangeY");
        this.offRangeZ = compound.func_74762_e("BlockOffRangeZ");
        if (compound.func_74764_b("BlockActivated")) {
            this.isActivated = compound.func_74767_n("BlockActivated");
        }
        this.availability.load(compound);
    }

    private void setActive(Block block, boolean bo) {
        this.isActivated = bo;
        IBlockState state = block.func_176223_P().func_177226_a((IProperty)BlockNpcRedstone.ACTIVE, (Comparable)Boolean.valueOf(this.isActivated));
        this.field_145850_b.func_180501_a(this.field_174879_c, state, 2);
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        block.func_176213_c(this.field_145850_b, this.field_174879_c, state);
    }

    public boolean shouldRefresh(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        --this.ticks;
        if (this.ticks > 0) {
            return;
        }
        this.ticks = this.onRange > 10 ? 20 : 10;
        Block block = this.func_145838_q();
        if (!(block instanceof BlockNpcRedstone)) {
            return;
        }
        if (CustomNpcs.FreezeNPCs) {
            if (this.isActivated) {
                this.setActive(block, false);
            }
            return;
        }
        if (!this.isActivated) {
            int z;
            int y;
            int x = this.isDetailed ? this.onRangeX : this.onRange;
            List<EntityPlayer> list = this.getPlayerList(x, y = this.isDetailed ? this.onRangeY : this.onRange, z = this.isDetailed ? this.onRangeZ : this.onRange);
            if (list.isEmpty()) {
                return;
            }
            for (EntityPlayer player : list) {
                if (!this.availability.isAvailable(player)) continue;
                this.setActive(block, true);
            }
        } else {
            int x = this.isDetailed ? this.offRangeX : this.offRange;
            int y = this.isDetailed ? this.offRangeY : this.offRange;
            int z = this.isDetailed ? this.offRangeZ : this.offRange;
            List<EntityPlayer> list = this.getPlayerList(x, y, z);
            for (EntityPlayer player : list) {
                if (!this.availability.isAvailable(player)) continue;
                return;
            }
            this.setActive(block, false);
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        compound.func_74768_a("BlockOnRange", this.onRange);
        compound.func_74768_a("BlockOffRange", this.offRange);
        compound.func_74757_a("BlockActivated", this.isActivated);
        compound.func_74757_a("BlockIsDetailed", this.isDetailed);
        compound.func_74768_a("BlockOnRangeX", this.onRangeX);
        compound.func_74768_a("BlockOnRangeY", this.onRangeY);
        compound.func_74768_a("BlockOnRangeZ", this.onRangeZ);
        compound.func_74768_a("BlockOffRangeX", this.offRangeX);
        compound.func_74768_a("BlockOffRangeY", this.offRangeY);
        compound.func_74768_a("BlockOffRangeZ", this.offRangeZ);
        this.availability.save(compound);
        return super.func_189515_b(compound);
    }
}

